<?php

	/**
	 * List tables in a database
	 *
	 * $Id: tblproperties.php,v 1.72.2.3 2007/07/11 07:59:27 ioguix Exp $
	 */

	// Include application functions
	include_once('./libraries/lib.inc.php');

	$action = (isset($_REQUEST['action'])) ? $_REQUEST['action'] : '';

	/**
	 * Show default list of columns in the table
	 */
	function doDefault($msg = '') {
		global $conf, $misc, $_server_info;
		global $lang;

		$misc->printTrail('table');
		$misc->printTabs('table','columns');
		$misc->printMsg($msg);

		// Get columns
		$attrs = $misc->getTableAttributes($_REQUEST['table']);

		$columns = array(
			'column' => array(
				'title' => $lang['strcolumn'],
				'field' => 'name',
			),
			'type' => array(
				'title' => $lang['strtype'],
				'field' => 'type',
			),
			'notnull' => array(
				'title' => $lang['strnotnull'],
				'field' => 'notnull',
				'type'  => 'yn'
			),
			'inherit' => array(
				'title' => $lang['strinherit'],
				'field' => 'inherit',
			),
			'indexed' => array(
				'title' => $lang['strindexed'],
				'field' => 'indexed',
				'type'  => 'yn'
			),
			'shared' => array(
				'title' => $lang['strshared'],
				'field' => 'shared',
				'type'  => 'yn'
			),
			'unique' => array(
				'title' => $lang['strunique'],
				'field' => 'unique',
				'type'  => 'yn'
			),
			'default' => array(
				'title' => $lang['strdefault'],
				'field' => 'dafault',
			),
			'actions' => array(
				'title' => $lang['stractions'],
			)
		);

		$actions = array(
		  //@@@TODO 1.2 alter
		  //@@@TODO 1.2 drop
		);

		$misc->printTable($attrs, $columns, $actions);
		
		echo "<br />\n";

		$tbl = $misc->getClass($_REQUEST['table']);
		if ($tbl['virtual'] == "view" && isset($tbl['queryspec'])) {
		  echo ("<table border=1 width=70%>\n");
	    echo "<tr><th>".$lang['queryspec']."</th></tr>\n";
	    echo "<tr><td>".$tbl['queryspec']."</td></tr>\n";
		  echo ("</table>\n");
  		echo "<br />\n";
		}


		echo "<ul>\n";
    if ($_server_info['broker']=="ON" &&
			  isset($_server_info['sqlport'])) {
  		//@@@TODO 1.2 browse
  		//@@@TODO 1.2 select
  		//@@@TODO 1.2 insert
  		//@@@TODO 1.2 import
  		//@@@TODO 1.2 export
		
  		echo "\t<li><a href=\"tables.php?action=confirm_empty&amp;{$misc->href}&amp;table=",
  		     urlencode($_REQUEST['table']),"\">{$lang['strempty']}</a></li>\n";
  	}
		echo "\t<li><a href=\"tables.php?action=confirm_drop&amp;{$misc->href}&amp;table=", urlencode($_REQUEST['table']),"\">{$lang['strdrop']}</a></li>\n";
		//@@@TODO 1.2 add
		//@@@TODO 1.2 table alter
		echo "</ul>\n";
	}

	$misc->printHeader($lang['strtables'] . ' - ' . $_REQUEST['table']);
	$misc->printBody();

	switch ($action) {
		default:
			doDefault();
			break;
	}
	
	$misc->printFooter();

?>
