/*
 * Decompiled with CFR 0.152.
 */
package info.jinwoomin.p1cartoon;

import info.jinwoomin.logging.ILoggable;
import info.jinwoomin.logging.ILogger;
import info.jinwoomin.logging.SimpleLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class P1Cartoon
implements PaintListener,
SelectionListener,
KeyListener,
ILoggable {
    private static final String PROPS_FILE_NAME = "p1cartoon.properties";
    private static final String PROP_PROGRAM_NAME = "p1cartoon.program.name";
    private static final String PROP_CARTOONS_FOLDER = "p1cartoon.cartoons.folder";
    private static final String PROP_ONE_IN_TWO_PAGES = "p1cartoon.1in2pages";
    private static final String PROP_RIGHT_TO_LEFT = "p1cartoon.right2left";
    private static final String PROP_CURR_IMAGE_NUM = "p1cartoon.curr.image.num";
    private static final String PROP_CURR_POSITION = "p1cartoon.curr.position";
    private static final String STR_PROGRAM_NAME = "P1Cartoon v0.2 by mio (yeoupooh)";
    private static final String STR_ONE_IN_TWO_PAGES = "1 in 2 Pages Image";
    private static final String STR_RIGHT_TO_LEFT = "Right To Left Navigation";
    private static final String STR_SET_FOLDER = "Set Cartoons Folder";
    private ILogger logger = null;
    private Display display = null;
    private Shell shell = null;
    private Canvas canvas = null;
    private Image image = null;
    private String imageFolder = new String();
    private List imageFiles = new ArrayList();
    private int currImageNum = 0;
    private int currPosition = 0;
    private boolean isOneInTwoPages = false;
    private boolean isRightToLeft = false;

    public void init() {
        this.logger.info("P1Cartoon v0.2 by mio (yeoupooh) started.");
        this.display = new Display();
        this.shell = new Shell(this.display);
        this.shell.setImage(ImageDescriptor.createFromURL((URL)this.getClass().getResource("/pooh.ico")).createImage());
        this.shell.setText(STR_PROGRAM_NAME);
        this.shell.setSize(300, 400);
        this.shell.addKeyListener((KeyListener)this);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        GridData gridData = new GridData(1808);
        this.canvas = new Canvas((Composite)this.shell, 0);
        this.image = ImageDescriptor.createFromURL((URL)this.getClass().getResource("/pooh.jpg")).createImage();
        this.canvas.addPaintListener((PaintListener)this);
        this.canvas.addKeyListener((KeyListener)this);
        this.canvas.setLayoutData((Object)gridData);
        this.canvas.setFocus();
        this.loadSettings();
        gridData = new GridData(768);
        Button chkOneInTwoPages = new Button((Composite)this.shell, 32);
        chkOneInTwoPages.setText(STR_ONE_IN_TWO_PAGES);
        chkOneInTwoPages.addKeyListener((KeyListener)this);
        chkOneInTwoPages.addSelectionListener((SelectionListener)this);
        chkOneInTwoPages.setSelection(this.isOneInTwoPages);
        gridData = new GridData(768);
        Button chkRightToLeft = new Button((Composite)this.shell, 32);
        chkRightToLeft.setText(STR_RIGHT_TO_LEFT);
        chkRightToLeft.addKeyListener((KeyListener)this);
        chkRightToLeft.addSelectionListener((SelectionListener)this);
        chkRightToLeft.setSelection(this.isRightToLeft);
        gridData = new GridData(768);
        Button btnSetFolder = new Button((Composite)this.shell, 0);
        btnSetFolder.setText(STR_SET_FOLDER);
        btnSetFolder.addKeyListener((KeyListener)this);
        btnSetFolder.addSelectionListener((SelectionListener)this);
        btnSetFolder.setLayoutData((Object)gridData);
        this.shell.setLayout((Layout)layout);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
        this.display.dispose();
        this.saveSettings();
        this.logger.info("P1Cartoon v0.2 by mio (yeoupooh) finishied.");
    }

    public static void main(String[] args) {
        P1Cartoon app = new P1Cartoon();
        app.setLogger(new SimpleLogger());
        app.init();
    }

    public void paintControl(PaintEvent e) {
        int srcHeight;
        int srcWidth;
        int srcY;
        int srcX;
        if (this.isOneInTwoPages) {
            srcX = this.image.getImageData().width / 2 * this.currPosition;
            srcY = 0;
            srcWidth = this.image.getImageData().width / 2;
            srcHeight = this.image.getImageData().height;
        } else {
            srcX = 0;
            srcY = 0;
            srcWidth = this.image.getImageData().width;
            srcHeight = this.image.getImageData().height;
        }
        e.gc.drawImage(this.image, srcX, srcY, srcWidth, srcHeight, 0, 0, this.canvas.getSize().x, this.canvas.getSize().y);
    }

    public void loadFileList() {
        int i;
        File file = new File(this.imageFolder);
        File[] files = file.listFiles();
        file = null;
        this.imageFiles.clear();
        if (files == null) {
            return;
        }
        this.logger.info("Loading file list.");
        for (i = 0; i < files.length; ++i) {
            if (!files[i].getName().toLowerCase().endsWith(".jpg") && !files[i].getName().toLowerCase().endsWith(".png") && !files[i].getName().toLowerCase().endsWith(".bmp") && !files[i].getName().toLowerCase().endsWith(".gif")) continue;
            this.imageFiles.add(files[i]);
        }
        for (i = 0; i < this.imageFiles.size(); ++i) {
            this.logger.debug(this.imageFiles.get(i).toString());
        }
        this.logger.info("File list loaded.");
    }

    public void widgetSelected(SelectionEvent e) {
        this.logger.debug(e.toString());
        String s = ((Button)e.getSource()).getText();
        if (s.equals(STR_SET_FOLDER)) {
            DirectoryDialog dlg = new DirectoryDialog(this.shell);
            dlg.setMessage("Choose cartoons folder");
            String dir = dlg.open();
            if (dir != null) {
                this.imageFolder = dir;
                this.logger.info("Choosed new cartoons folder. [" + this.imageFolder + "]");
                this.currImageNum = 0;
                this.loadFileList();
                this.reloadImage();
                this.canvas.redraw();
            } else {
                this.logger.info("Setting new cartoons folder canceled.");
            }
            Object var3_3 = null;
        } else if (s.equals(STR_ONE_IN_TWO_PAGES)) {
            this.isOneInTwoPages = ((Button)e.getSource()).getSelection();
            this.canvas.redraw();
        } else if (s.equals(STR_RIGHT_TO_LEFT)) {
            this.isRightToLeft = ((Button)e.getSource()).getSelection();
            this.canvas.redraw();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void reloadImage() {
        if (this.imageFiles.size() > 0) {
            File imageFile = (File)this.imageFiles.get(this.currImageNum);
            this.image.dispose();
            this.image = new Image((Device)this.display, imageFile.getAbsolutePath());
            this.logger.info("New image loaded. [" + imageFile.getName() + "]");
        }
    }

    public void goNextPage() {
        ++this.currImageNum;
        if (this.currImageNum > this.imageFiles.size() - 1) {
            this.currImageNum = this.imageFiles.size() - 1;
        }
    }

    public void goPrevPage() {
        --this.currImageNum;
        if (this.currImageNum < 0) {
            this.currImageNum = 0;
        }
    }

    public void keyPressed(KeyEvent e) {
        this.logger.debug(e.toString());
        switch (e.keyCode) {
            case 0x1000006: {
                this.logger.debug("page down");
                if (this.isOneInTwoPages) {
                    if (this.isRightToLeft) {
                        if (this.currPosition == 0) {
                            this.currPosition = 1;
                            this.goNextPage();
                        } else {
                            this.currPosition = 0;
                        }
                    } else if (this.currPosition == 1) {
                        this.currPosition = 0;
                        this.goNextPage();
                    } else {
                        this.currPosition = 1;
                    }
                } else {
                    this.goNextPage();
                }
                this.reloadImage();
                this.canvas.redraw();
                break;
            }
            case 0x1000005: {
                this.logger.debug("page up");
                if (this.isOneInTwoPages) {
                    if (this.isRightToLeft) {
                        if (this.currPosition == 1) {
                            this.currPosition = 0;
                            this.goPrevPage();
                        } else {
                            this.currPosition = 1;
                        }
                    } else if (this.currPosition == 0) {
                        this.currPosition = 1;
                        this.goPrevPage();
                    } else {
                        this.currPosition = 0;
                    }
                } else {
                    this.goPrevPage();
                }
                this.reloadImage();
                this.canvas.redraw();
            }
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveSettings() {
        Properties props = new Properties();
        props.setProperty(PROP_PROGRAM_NAME, STR_PROGRAM_NAME);
        props.setProperty(PROP_CARTOONS_FOLDER, this.imageFolder);
        this.logger.debug("currImageNum=" + this.currImageNum);
        props.setProperty(PROP_CURR_IMAGE_NUM, new Integer(this.currImageNum).toString());
        props.setProperty(PROP_CURR_POSITION, new Integer(this.currPosition).toString());
        props.setProperty(PROP_ONE_IN_TWO_PAGES, new Boolean(this.isOneInTwoPages).toString());
        props.setProperty(PROP_RIGHT_TO_LEFT, new Boolean(this.isRightToLeft).toString());
        try {
            props.store(new FileOutputStream(PROPS_FILE_NAME), "P1Cartoon v0.2 by mio (yeoupooh) Settings");
            this.logger.info("Settings saved.");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            props.clear();
            props = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadSettings() {
        Properties props = new Properties();
        try {
            props.load(new FileInputStream(PROPS_FILE_NAME));
            this.imageFolder = props.getProperty(PROP_CARTOONS_FOLDER, "");
            this.currImageNum = Integer.parseInt(props.getProperty(PROP_CURR_IMAGE_NUM));
            this.currPosition = Integer.parseInt(props.getProperty(PROP_CURR_POSITION));
            this.isOneInTwoPages = Boolean.parseBoolean(props.getProperty(PROP_ONE_IN_TWO_PAGES));
            this.isRightToLeft = Boolean.parseBoolean(props.getProperty(PROP_RIGHT_TO_LEFT));
            this.logger.info("Settings loaded.");
            if (this.imageFolder != null) {
                this.loadFileList();
                this.reloadImage();
                this.canvas.redraw();
            }
        }
        catch (NumberFormatException e) {
            this.logger.warn("Can't load settings.");
        }
        catch (FileNotFoundException e) {
            this.logger.warn("Can't load settings.");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            props.clear();
            props = null;
        }
    }

    public void setLogger(ILogger logger) {
        this.logger = logger;
    }
}

