<?php
/* vim600: et ts=4 sts=4 sw=4 fdm=marker
 *
 * EtchiBBS UTF-8 - Gallery Web Board
 * Copyright (C) 2004 EtchiBoard Project
 * 
 * See LICENSE for license condition.
 *
 * http://etchibbs.kldp.net
 * $Id: search.php,v 1.65 2004/03/23 16:41:36 lseeker Exp $
 */

require 'lib/common.php';
include 'lib/layout.php';
include 'lib/article.php';
include 'lib/list.inc';
include 'lib/list.class.php';

if (empty($_GET['word']) || empty($_GET['type'])) error_exit('검색어 및 검색 방식을 입력해 주세요.', TRUE);

$word = get_magic_quotes_gpc() ? stripslashes($_GET['word']) : $_GET['word'];
$type = $_GET['type'];

/* FIXME UTF-8에서는 비적합. 일단 3바이트(한글로는 1)에서 자름... ==3 */
/* 검색 방법을 바꿔서 부하는 적을텐데... 필요한걸까나? */
if (strlen($word) < 3) error_exit('검색어가 너무 짧습니다.', TRUE);

$allow_type = array('name' => 'name', 'subject' => 'subject', 'content' => 'ment', 'image' => 'cfile');

if (!isset($allow_type[$type])) error_exit('적합하지 않은 검색 방식입니다', TRUE);

$dbt = $allow_type[$type];
$dbw = str_replace('%', '\\\\%', addslashes($word));

session_start();

if (empty($_GET['page']) || !isset($_SESSION['search'][$type][$word])) {
    /* 검색 리스트 만들기 */
    $List = new DBResult($DB->query("SELECT idx FROM hboard_db_article WHERE deleted='f' AND {$dbt} LIKE '%{$dbw}%' ORDER BY idx DESC"));
    if (isset($_SESSION['search'][$type][$word])) unset($_SESSION['search'][$type][$word]);
    $_SESSION['search'][$type][$word] = array();
    while ($index = $List->fetch()) $_SESSION['search'][$type][$word][] = $index['idx'];
    $List->free();
}

if (!empty($_GET['page'])) {
    $page = (int) $_GET['page'];
    if ($page < 1) $page = 1;
} else {
    $page = 1;
}

$total_article_num = count($_SESSION['search'][$type][$word]);

if (!$total_article_num) error_exit('검색 결과가 없습니다.', TRUE);

$end = $page * $admin_data['app'] - 1;
if ($end >= $total_article_num) $end = $total_article_num - 1;

for ($i = ($page - 1) * $admin_data['app']; $i <= $end; $i++) $list_in[] = $_SESSION['search'][$type][$word][$i];

if (!isset($list_in)) error_exit('존재하지 않는 페이지입니다.', TRUE);

$dbin = implode(',', $list_in);

$Result = new DBResult($DB->query("SELECT idx, name, email, home, ipaddr, date, cfile, subject, ment, deleted, reply, agent FROM hboard_db_article WHERE idx IN ({$dbin}) ORDER BY idx DESC"));

$type_str_list = array('name' => '작성자', 'subject' => '글 제목', 'content' => '글 내용', 'image' => '파일 이름');

$Layout = new Layout($admin_data);

$ToolBox = new ToolBox;
$ToolBox->registerContent("{$type_str_list[$type]}에 대한 검색어 <b>{$word}</b>(으)로 {$total_article_num}개의 결과가 검색되었습니다. [<a href=\"list.php\"><b>목록으로 돌아가기</b></a>]<br />현재 {$page} 페이지 / 전체 " . intval(($total_article_num + $admin_data['app'] - 1) / $admin_data['app']) . " 페이지 (페이지당 {$admin_data['app']}개씩 출력)");

$ArticleBox = new ArticleBox;
$ArticleBox->readConfig($admin_data);
$ArticleBox->registerPage($page);

$Reply = new Reply($DB->query("SELECT * FROM hboard_db_comment WHERE article IN ({$dbin}) ORDER BY article DESC, idx ASC"));
$DB->close();
$Reply->prepareNext();
$ArticleBox->registerReply($Reply);

$Paging = new Paging;
$Paging->registerAddress("search.php?type={$type}&amp;word=" . rawurlencode($word) . '&amp;page=');
$Paging->registerTotalNum($total_article_num);
$Paging->registerNowPage($page);
$Paging->registerNumPerPage($admin_data['app']);
$Paging->hideStats();

$SearchForm = new SearchForm;
$SearchForm->registerType($type);
$SearchForm->registerWord($word);

$Article = new Article;

if ($admin['login']) {
    $ToolBox->showAdminTools();
    $ArticleBox->showIPAddress();
}

$Layout->printHeader();
echo "<script type=\"text/javascript\">\n<!--\nfunction show_comment_form(n) {\nreturn true;\n}\n//-->\n</script>";
$ToolBox->printOut();
while ($Article->readDB($Result->fetch())) {
    $ArticleBox->registerArticle($Article);
    $ArticleBox->highlight($type, $word);
    $ArticleBox->printOut();
}
$Result->free();
$Reply->free();

$Paging->printOut();
$SearchForm->printOut();

echo '<p class="center fontBold">[<a href="list.php">목록으로 돌아가기</a>]</p>';
$Layout->printFooter();

?>
