<?php
/* vim600: et ts=4 sts=4 sw=4 fdm=marker
 *
 * EtchiBBS UTF-8 - Gallery Web Board
 * Copyright (C) 2004 EtchiBoard Project
 * 
 * See LICENSE for license condition.
 *
 * http://etchibbs.kldp.net
 * $Id: modify.php,v 1.32 2004/03/23 16:41:36 lseeker Exp $
 */

require 'lib/common.php';
include 'lib/layout.php';
include 'lib/writeform.php';
include 'lib/article.php';
include 'lib/list.inc';

if(empty($_GET['article_no'])) error_exit('<b>게시물 정보가 없습니다.</b><br />modify.php?article_no=[번호] 식으로 입력하세요.', TRUE);

$article_no = (int) $_GET['article_no'];
/* 게시물 정보 읽어오기 (...재미있는 기능도 좀 있고 해서 -_-a) */
$Result = new DBResult($DB->query("SELECT idx, name, email, home, ipaddr, date, cfile, subject, ment, deleted, reply, agent FROM hboard_db_article WHERE idx={$article_no}"));

if (!$Result->numrows) error_exit('해당 게시물이 존재하지 않습니다.', TRUE);

$Article = new Article;
$Article->readDB($Result->fetch());
$Result->free();

/* 게시물 삭제여부 체크, 이상없으면 수정폼 보이기 */
if ($Article->deleted) error_exit('게시물이 이미 삭제된 상태입니다.', TRUE);

$Layout = new Layout($admin_data);

$ModifyForm = new WriteForm('modify');
$ModifyForm->registerTitle("{$article_no}번 게시물 수정하기..");
$ModifyForm->registerHiddenInput("<input type=\"hidden\" name=\"article_no\" value=\"{$article_no}\" /><input type=\"hidden\" name=\"page\" value=\"" . intval($_GET['page']) . '" />');
$ModifyForm->readArticle($Article);

$ArticleBox = new ArticleBox;
$ArticleBox->readConfig($admin_data);
$ArticleBox->hideButtons();
$ArticleBox->registerArticle($Article);

$Reply = new Reply($DB->query("SELECT * FROM hboard_db_comment WHERE article={$article_no} ORDER BY article, idx ASC"));
$DB->close();
$Reply->prepareNext();
$ArticleBox->registerReply($Reply);

if ($admin['login']) {
    $ModifyForm->hidePasswordInput();
    $ArticleBox->showIPAddress();
}

$Layout->printHeader();
$ModifyForm->show();
$ArticleBox->printOut();
$Layout->printFooter();

$Reply->free();

?>
