<?php
/* vim600: et ts=4 sts=4 sw=4 fdm=marker
 *
 * EtchiBBS UTF-8 - Gallery Web Board
 * Copyright (C) 2004 EtchiBoard Project
 * 
 * See LICENSE for license condition.
 *
 * http://etchibbs.kldp.net
 * $Id: comment.php,v 1.42 2004/03/23 16:41:36 lseeker Exp $
 */

require 'lib/common.php';
include 'lib/layout.php';
include 'lib/writeform.php';
include 'lib/article.php';
include 'lib/list.inc';

if(!isset($_GET['article'])) error_exit('<b>게시물 정보가 없습니다.</b><br />comment.php?article=[번호] 식으로 입력하세요.', TRUE);

$article_no = (int) $_GET['article'];

$Result = new DBResult($DB->query("SELECT idx, name, email, home, ipaddr, date, cfile, subject, ment, deleted, reply, agent FROM hboard_db_article WHERE idx={$article_no}"));

/* 글이 없을 경우의 처리 */
if (!$Result->numrows()) error_exit('<b>존재하지 않는 게시물입니다.</b>', TRUE);

$Article = new Article;
$Article->readDB($Result->fetch());
$Result->free();

if ($Article->deleted) error_exit('<b>삭제된 게시물입니다.</b>', TRUE);

$Layout = new Layout($admin_data);

$CommentForm = new WriteForm('comment');
$CommentForm->registerTitle("{$article_no}번 게시물에 의견 남기기");
$CommentForm->registerHiddenInput("<input type=\"hidden\" name=\"article\" value=\"{$article_no}\" /><input type=\"hidden\" name=\"page\" value=\"" . intval($_GET['page']) . '" />');
$CommentForm->readCookie();
$CommentForm->registerPreviewImage(strcmp($CommentForm->icon, '') && file_exists('db/ico/'. $CommentForm->icon) ? 'db/ico/' . rawurlencode($CommentForm->icon) : "skin/{$admin_data['skin']}/none.jpg");

$ArticleBox = new ArticleBox;
$ArticleBox->readConfig($admin_data);
if ($admin['login']) $ArticleBox->showIPAddress();
$ArticleBox->hideButtons();
$ArticleBox->registerArticle($Article);

$Reply = new Reply($DB->query("SELECT * FROM hboard_db_comment WHERE article={$article_no} ORDER BY article, idx ASC"));
$DB->close();
$Reply->prepareNext();
$ArticleBox->registerReply($Reply);

$Layout->printHeader();
$CommentForm->show();
$ArticleBox->printOut();
$Layout->printFooter();

?>
