<?php
/* $Id$ */

function do_dhon($formatter,$options)
{
	if($options['mode'] == 'devhelp')
		dhon_devhelp($formatter,$options);
	else if($options['mode'] == 'library')
		dhon_library($formatter,$options);
	else if($options['mode'] == 'html')
		dhon_html($formatter,$options);
	else {
		$formatter->send_header("Status: 406 Not Acceptable",$options);
		$formatter->send_title("406 Not acceptable","",$options);
		$formatter->send_page("== ".sprintf("%s is not valid mode",$options['mode'])." ==\n");
		$formatter->send_footer("",$options);
	}
}

function dhon_library($formatter,$options)
{
	global $DBInfo;

	$MACRO_LIBRARY="DHONLibrary";
	$QUERY_DEVHELP="?action=dhon&mode=devhelp";

	$host_uri = dhon_get_host_uri($formatter,$options);
	$content = $formatter->page->get_raw_body();

	/* create a xmltree of library */
	$doc = domxml_new_doc("1.0");
	$root = $doc->create_element("library");
	$root = $doc->append_child($root);
	$node_depth[0] = $root;

	$lines = explode("\n",$content);

	foreach($lines as $line){
		$line = preg_replace("/\n$/","",$line);
		
		if(preg_match("/\[\[$MACRO_LIBRARY\(([A-Za-z]+),([^)]+)\)\]\]/",
					$line,$match))
		{
			$attr_name=$match[1];
			$attr_desc=$match[2];
		} else if(preg_match("/(?<!=)(={1,5})\s(#?)(.*)\s+\\1\s?$/",
					$line,$match))
		{
			$dep = strlen($match[1]);

			$head = str_replace("<","&lt;",$match[3]);
			/* strip some basic wikitags */
			$head = preg_replace($formatter->baserule,"\\1",$head);
			$head = preg_replace("/\[(.*)\]/","\\1",$head);

			$new_node = $doc->create_element("category");
			$new_node->set_attribute("name",$head);
		
			$node_depth[$dep] = $node_depth[$dep-1]->append_child($new_node);
		}else if(preg_match("/(\* \[([^\]]*)\])/",$line,$match)){
			$new_node = $doc->create_element("book");
			$new_node->set_attribute("title",$match[2]);
			$new_node->set_attribute("uri",$host_uri.
					$formatter->link_url($match[2]).
			        $QUERY_DEVHELP);
			$node_depth[$dep]->append_child($new_node);
		}

	}
	
	if($attr_name == FALSE)
		$attr_name = $DBInfo->sitename;

	if($attr_desc == FALSE)
		$attr_desc = $DBInfo->sitename;
	
	$root->set_attribute("version","1.0");
	$root->set_attribute("name",$attr_name);
	$root->set_attribute("mtime",$formatter->page->mtime());
	
	header("Content-Type: text/xml");
	echo $doc->dump_mem(TRUE);
}

function dhon_devhelp($formatter,$options)
{
	global $DBInfo;

	$QUERY_HTML="?action=dhon&mode=html";

			   	
	$content = $formatter->page->get_raw_body();
	if($DBInfo->charset != 'utf8')
		$content = iconv($DBInfo->charset,"utf8",$content);

	/* create a xml tree of book */
	$doc = domxml_new_doc("1.0");
	$root = $doc->create_element("book");
	$root = $doc->append_child($root);
	$root->set_attribute("name",$formatter->page->name);
	$root->set_attribute("version",$formatter->page->get_rev());
	$root->set_attribute("title",$formatter->page->name);
	$root->set_attribute("link",dhon_get_book_uri($formatter,$options,$QUERY_HTML));
	$chapters = $doc->create_element("chapters");
	$chapters = $root->append_child($chapters);
	$node_depth[0] = $chapters;

	$functions = $doc->create_element("functions");
	$functions = $root->append_child($functions);


	$book_uri = dhon_get_book_uri($formatter,$options,$QUERY_HTML);

	for($i=1;$i<=5;$i++)
		$toc[$i] = 0;

	$lines = explode("\n",$content);
	$esc_flag = 0;

	foreach($lines as $line){
		$line = preg_replace("/\n$/","",$line);
		
		if(preg_match("/^{{{/",$line,$match))
			$esc_flag=1;

		if($esc_flag == 1 && preg_match("/^}}}/",$line,$match))
			$esc_flag=0;

		if($esc_flag)
			continue;
				
		if(preg_match("/(?<!=)(={1,5})\s(#?)(.*)\s+\\1\s?$/",$line,$match))
		{

			$dep = strlen($match[1]);

			$head = str_replace("<","&lt;",$match[3]);
			/* strip some basic wikitags */
			$head = preg_replace($formatter->baserule,"\\1",$head);
			$head = preg_replace("/\[(.*)\]/","\\1",$head);

			$toc[$dep] += 1;
			dhon_toc_clear(&$toc,$dep);

			$new_node = $doc->create_element("sub");
			$new_node->set_attribute("name",$head);
			$link = dhon_link_url($book_uri,$toc,$dep);
			$new_node->set_attribute("link",$link);

			$node_depth[$dep] = $node_depth[$dep-1]->append_child($new_node);
		}

		if(preg_match("/[^']''([^']*)''[^']/",$line,$match))
		{
			$function = $doc->create_element("function");
			$function->set_attribute("name",$match[1]);
			$function->set_attribute("link",$link);
			$function = $functions->append_child($function);
		}
				
	}

	header("Content-Type: text/xml; charset=utf-8");
	echo $doc->dump_mem(TRUE);
}

function dhon_html ($formatter, $options) {
	global $DBInfo;

	$HOSTNAME="http://".$_SERVER['SERVER_NAME'];
	$BASE_URI=$HOSTNAME.$DBInfo->url_prefix;
	$IMG_URI=$HOSTNAME.$DBInfo->imgs_dir;
	$CSS_URI=$BASE_URI."/css";
	$options['css_url']=$CSS_URI."/dhon.css";

	$formatter->send_header("",$options);
	print "<div id='Logo'>";
	print "<img src='".$IMG_URI."/dhon.png' alt='DevHelpOnNet Logo'/>";
	print "</div>";
	print "<div id='WikiTitle'>";
	print "<h1>$options[page]</h1>";
	print "</div>";
	print "<div id='wikiContent'>";
	$formatter->external_on=1;
	$formatter->send_page();
	print "</div>";
    print "<div class='printFooter'>&nbsp;";
	print "</div>";
	print "</body></html>";
	return;
}

function dhon_get_book_uri($formatter,$options,$query='')
{
	return "http://".$_SERVER['SERVER_NAME'].
		$formatter->link_url($formatter->page->urlname).
			$query;
}

function dhon_get_host_uri($formatter,$options,$query='')
{
	return "http://".$_SERVER['SERVER_NAME'];
}

/*function dhon_get_book_name($formatter,$options)
{
	if($_GET['cache'] == 'true')
		return $formatter->page->urlname.".htm";
	else return $formatter->link_url($formatter->page->urlname);
}*/

function dhon_toc_clear(&$toc,$dep)
{
	for($i=$dep+1;$i <= 5;$i++)
		$toc[$i] = 0;
}	

function dhon_link_url($book_uri,$toc,$dep)
{
	for($i = 1; $i <= $dep;$i ++)
	{
		if($i == 1)
			$anchor = $toc[$i];
		else
			$anchor = $anchor.".".$toc[$i];
	}

	return "$book_uri#s-".$anchor;
}

?>
